# Troubleshooting

## I flashed the firmware but the modem is stuck in fastboot
Fastboot needs a second reboot to clear the flag to force it into fastboot, please run `fastboot reboot` again
Type in `lsusb` at your terminal and see if the following line appears and disappears after 2-3 seconds:

`Bus 002 Device 004: ID 18d1:d00d Google Inc. Xiaomi Mi/Redmi 2 (fastboot)`

## I'm using your firmware and don't know how to enter fastboot modem
If you have ADB on, just run (as root): `adb shell reboot; fastboot oem stay`
If you have ADB off, just run (as root): `sudo sh -c 'echo -ne "AT+QFASTBOOT\r" > /dev/ttyUSB2'`

## My modem won't boot anymore
If your modem doesn't boot at all, you can try these to get into fastboot and flash it again

### Distributions running eg25manager
1. Open a root terminal and run `fastboot oem stay &`
2. Turn off the modem kill switch, wait a few seconds and turn it on again
3. Restart eg25 manager service (`systemctl restart eg25-manager` if using systemd)
4. The modem will automatically start in fastboot mode

### Distributions running Megi's modem-power kernel
Open a root terminal and run the following commands
1. `echo 0 > /sys/class/modem-power/modem-power/device/powered`
2. `fastboot oem stay &`
3. `echo 1 > /sys/class/modem-power/modem-power/device/powered`

## Getting logs to help with an issue
The best way to debug a problem is having all the available logs to be able to pinpoint what is going on and what caused it. Must have logs would be:
- Pinephone's kernel log
- Modem's kernel log 
- Logs generated by openqti (stored in the modem at /var/log/openqti.log)
- If possible, NetworkManager, ModemManager / oFono and eg25manager logs will come handy too

If you're running a distro using Systemd, you can use [@kkeijzer's script](https://github.com/Biktorgj/pinephone_modem_sdk/blob/hardknott/tools/helpers/collect_logs) to grab them all in one go

Make sure you have ADB enabled (`sudo sh -c 'echo -ne "AT+ADBON\r" > /dev/ttyUSB2'`) or the script won't work!

If you want to only get some specific log:
- Pinephone's kernel log: `dmesg > dmesg-pinephone.log`
- Modem's kernel log: `adb shell dmesg > dmesg-modem.log`
- OpenQTI: `adb pull /var/log/openqti.log`
- NetworkManager (if using Systemd): `journalctl -u NetworkManager.service -e > networkmanager.log`
- ModemManager (if using Systemd): `journalctl -u ModemManager.service -e > ModemManager.log`
- EG25-Manager (if using Systemd): `journalctl -u eg25-manager.service -e > eg25-manager.log`

